using System;
using System.Web;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using VIRP.CRS.BLL;
using VIRP.CRS.BO;

namespace VIRP.CRS.DAL
{
	public partial class PATIENT_UDFsDB : DBUtils
	{
        #region Fields
        #endregion

        #region Constructors

        public PATIENT_UDFsDB()
        {
        }

        #endregion

        #region Properties
        #endregion

        #region Methods

        public Int32 Save(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, PATIENT_UDFs objSave)
        {
            Int32 objReturn = 0;

            SqlConnection sConn = null;
            SqlCommand sCmd = null;
            SqlParameter p = null;
            SqlDataAdapter sAdapter = null;
            DataSet objTemp = null;

            try
            {
                sConn = new SqlConnection(SqlConnectionString);

                sConn.Open();

                sCmd = new SqlCommand("CRS.usp_PATIENT_UDFs_save", sConn);
                sCmd.CommandTimeout = SqlCommandTimeout;
                sCmd.CommandType = CommandType.StoredProcedure;
                sCmd.Parameters.AddWithValue("@CURRENT_USER", CURRENT_USER);
                sCmd.Parameters.AddWithValue("@CURRENT_REGISTRY_ID", CURRENT_REGISTRY_ID);

                p = new SqlParameter("@CREATED", SqlDbType.DateTime, 8);
                p.Precision = 23;
                p.Scale = 3;
                AddParameter(ref sCmd, ref p, objSave.CREATED);
                p = new SqlParameter("@CREATEDBY", SqlDbType.VarChar, 30);
                p.Precision = 0;
                p.Scale = 0;
                AddParameter(ref sCmd, ref p, objSave.CREATEDBY);
                p = new SqlParameter("@ID", SqlDbType.Int, 4);
                p.Direction = ParameterDirection.InputOutput;
                p.Precision = 10;
                p.Scale = 0;
                AddParameter(ref sCmd, ref p, objSave.ID);
                p = new SqlParameter("@PATIENT_ID", SqlDbType.Int, 4);
                p.Precision = 10;
                p.Scale = 0;
                AddParameter(ref sCmd, ref p, objSave.PATIENT_ID);
                p = new SqlParameter("@STD_REG_UDFs_ID", SqlDbType.Int, 4);
                p.Precision = 10;
                p.Scale = 0;
                AddParameter(ref sCmd, ref p, objSave.STD_REG_UDFs_ID);
                p = new SqlParameter("@UDF_Value", SqlDbType.VarChar, -1);
                p.Precision = 0;
                p.Scale = 0;
                AddParameter(ref sCmd, ref p, objSave.UDF_Value);
                p = new SqlParameter("@UPDATED", SqlDbType.DateTime, 8);
                p.Precision = 23;
                p.Scale = 3;
                AddParameter(ref sCmd, ref p, objSave.UPDATED);
                p = new SqlParameter("@UPDATEDBY", SqlDbType.VarChar, 30);
                p.Precision = 0;
                p.Scale = 0;
                AddParameter(ref sCmd, ref p, objSave.UPDATEDBY);

                objTemp = new DataSet();
                sAdapter = new SqlDataAdapter(sCmd);

                LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                //int cnt = sCmd.ExecuteNonQuery();
                sAdapter.Fill(objTemp);
                LogManager.LogTiming(logDetails);
                CheckDataSet(objTemp);

                objReturn = (Int32)sCmd.Parameters["@ID"].Value;

                sConn.Close();
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }
            finally
            {
                if (sAdapter != null)
                {
                    sAdapter.Dispose();
                    sAdapter = null;
                }
                if (sCmd != null)
                {
                    sCmd.Dispose();
                    sCmd = null;
                }
                if (sConn != null)
                {
                    if (sConn.State != ConnectionState.Closed) { sConn.Close(); }
                    sConn.Dispose();
                    sConn = null;
                }
            }

            return objReturn;
        }

        public PATIENT_UDFs GetItemByPatientUdf(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 PATIENT_ID, Int32 STD_REG_UDFs_ID)
        {
            PATIENT_UDFs objReturn = null;

            SqlConnection sConn = null;
            SqlCommand sCmd = null;
            SqlDataAdapter sAdapter = null;
            DataSet objTemp = null;

            try
            {
                sConn = new SqlConnection(SqlConnectionString);

                sConn.Open();

                sCmd = new SqlCommand("CRS.usp_PATIENT_UDFs_getitemByPatientUdf", sConn);
                sCmd.CommandTimeout = SqlCommandTimeout;
                sCmd.CommandType = CommandType.StoredProcedure;
                sCmd.Parameters.AddWithValue("@CURRENT_USER", CURRENT_USER);
                sCmd.Parameters.AddWithValue("@CURRENT_REGISTRY_ID", CURRENT_REGISTRY_ID);
                sCmd.Parameters.AddWithValue("@PATIENT_ID", PATIENT_ID);
                sCmd.Parameters.AddWithValue("@STD_REG_UDFs_ID", STD_REG_UDFs_ID);

                objTemp = new DataSet();
                sAdapter = new SqlDataAdapter(sCmd);

                LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                sAdapter.Fill(objTemp);
                LogManager.LogTiming(logDetails);
                CheckDataSet(objTemp);

                if (objTemp != null && objTemp.Tables.Count > 0 && objTemp.Tables[0].Rows.Count > 0)
                {
                    objReturn = ParseReader(objTemp.Tables[0].Rows[0]);
                }

                sConn.Close();
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }
            finally
            {
                if (sAdapter != null)
                {
                    sAdapter.Dispose();
                    sAdapter = null;
                }
                if (sCmd != null) 
                { 
                    sCmd.Dispose(); 
                    sCmd = null; 
                }
                if (sConn != null)
                {
                    if (sConn.State != ConnectionState.Closed) { sConn.Close(); }
                    sConn.Dispose();
                    sConn = null;
                }
            }

            return objReturn;
        }

        public PATIENT_UDFs ParseReader(DataRow row)
        {
            PATIENT_UDFs objReturn = new PATIENT_UDFs
            {
                CREATED = (DateTime)GetNullableObject(row.Field<object>("CREATED")),
                CREATEDBY = (string)GetNullableObject(row.Field<object>("CREATEDBY")),
                ID = (Int32)GetNullableObject(row.Field<object>("ID")),
                PATIENT_ID = (Int32)GetNullableObject(row.Field<object>("PATIENT_ID")),
                STD_REG_UDFs_ID = (Int32)GetNullableObject(row.Field<object>("STD_REG_UDFs_ID")),
                UDF_Value = (string)GetNullableObject(row.Field<object>("UDF_Value")),
                UPDATED = (DateTime)GetNullableObject(row.Field<object>("UPDATED")),
                UPDATEDBY = (string)GetNullableObject(row.Field<object>("UPDATEDBY"))
            };

            return objReturn;
        }

        #endregion
    }
}
